<?= $this->extend('layouts/layout_main') ?>
<?= $this->section('content') ?>
<?= $this->include('partials/page_title') ?>

<div class="container-fluid mb-5">
    <div class="row">
        <div class="col content-box p-4">

            <div class="row">
                <div class="col-sm-6 col-10">
                    <?= form_open('/users_management/new_user_submit') ?>

                    <div class="row">
                        <div class="col">
                            <div class="mb-3">
                                <p>Restaurante: <strong><?= session()->user['restaurant_name'] ?></strong></p>
                                <hr>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-sm-6 col-12">
                            <label for="text_username" class="form-label">Usuário</label>
                            <input type="text" class="form-control" name="text_username" required value="<?= old('text_username') ?>">
                            <?= display_error('text_username', $validation_errors) ?>
                        </div>
                        <div class="col-sm-6 col-12">
                            <label for="text_name" class="form-label">Nome do usuário</label>
                            <input type="text" class="form-control" name="text_name" required value="<?= old('text_name') ?>">
                            <?= display_error('text_name', $validation_errors) ?>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-sm-6 col-12">
                            <label for="text_email" class="form-label">E-mail</label>
                            <input type="email" class="form-control" name="text_email" required value="<?= old('text_email') ?>">
                            <?= display_error('text_email', $validation_errors) ?>
                        </div>
                        <div class="col-sm-6 col-12">
                            <label for="text_phone" class="form-label">Telefone</label>
                            <input type="text" class="form-control" name="text_phone" required value="<?= old('text_phone') ?>">
                            <?= display_error('text_phone', $validation_errors) ?>
                        </div>
                    </div>

                    <div class="row mb-5">
                        <div class="col-6">
                            <label class="form-label">Perfil</label>
                            <select name="select_role" class="form-select">
                                <option value="admin" <?= old('select_role') == 'admin' ? 'selected' : '' ?>>Administrador</option>
                                <option value="user" <?= old('select_role') == 'user' ? 'selected' : '' ?>>Colaborador</option>
                            </select>
                            <?= display_error('select_role', $validation_errors) ?>
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col">
                            <a href="<?= site_url('/users_management') ?>" class="btn btn-outline-secondary px-5"><i class="fa-solid fa-ban me-2"></i>Cancelar</a>
                            <button type="submit" class="btn btn-outline-success px-5"><i class="fa-solid fa-check me-2"></i>Criar usuário</button> 
                        </div>
                    </div>

                    <?= form_close() ?>

                    <?php if(!empty($server_error)) : ?>
                        <div class="alert alert-danger">
                            <?= $server_error ?>
                        </div>
                    <?php endif ; ?>

                </div>
            </div>
        </div>
    </div>
</div>

<?= $this->endSection() ?>