<?= $this->extend('layouts/layout_main') ?>
<?= $this->section('content') ?>
<?= $this->include('partials/page_title') ?>

<div class="content-box">
    <?= form_open_multipart('/products/edit_submit') ?>

    <input type="hidden" name="id_product" value="<?= Encrypt($product->id) ?>">

    <div class="row">
        <!-- Coluna da imagem -->
        <div class="col-lg-4 col-4 p-5 px-3 border rounded border-light-subtle shadow-sm" style="margin-left: 20px;">
            <!-- image -->
            <div class="text-center">
                <img src="<?= base_url('assets/images/products/' . $product->image) ?>" class="product-image img-fluid" id="product_image">
            </div>

            <!-- file upload -->
            <div class="mt-3 text-start">
                <label for="file_image" class="form-label2">Imagem do produto</label>
                <input type="file" name="file_image" id="file_image" class="form-control" accept="image/png">
                <?= display_error('file_image', $validation_errors) ?>
            </div>
        </div>

         <!-- Coluna dos dados -->
        <div class="col-lg-7 col-6 p-5 px-3 pt-3" style="margin-left: 20px;">
            <div class="row">
                <!-- name -->
                <div class="col-lg-12 col-12">
                    <div class="mb-3">
                        <label for="name" class="form-label2">Nome do produto</label>
                        <input type="text" name="text_name" id="text_name" class="form-control" placeholder="Nome do produto" value="<?= old('text_name', $product->nome) ?>">
                        <?= display_error('text_name', $validation_errors) ?>
                    </div>
                </div>
            </div>
            <div class="row">
                <!-- description -->
                <div class="col-lg-12 col-10">
                    <div class="mb-3">
                        <label for="description" class="form-label2">Descrição do produto</label>
                        <input type="text" name="text_description" id="text_description" class="form-control" placeholder="Descrição do produto" value="<?= old('text_description', $product->descricao) ?>">
                        <?= display_error('text_description', $validation_errors) ?>
                    </div>
                </div>
            </div>
         
            <!-- category and price -->
            <div class="row">
                <div class="col-sm-8">
                    <!-- Seleção da categoria -->
                    <div class="mb-2">
                        <label for="descricao" class="form-label2">Categoria</label>
                        <select class="form-select" id="text_categoria" name="text_categoria" aria-label="Default select example">
                            <option selected>Selecione</option>
                            <?php $categoria_selecionada = $product->id_categoria; ?>
                            <?php foreach($categorias as $categoria): ?>
                                <option value="<?= $categoria->id ?>" <?php if ($categoria->id == $categoria_selecionada) echo 'selected' ?>>
                                <?= $categoria->descricao ?>
                            <?php endforeach; ?>
                        </select>
                    </div>    
                </div>   
                
                <div class="col-sm-4 ">
                    <div class="mb-2">
                        <label for="price" class="form-label2">Preço</label>
                        <input type="text" name="text_price" id="text_price" class="form-control" placeholder="Preço" value="<?= old('text_price', preg_replace("/\./", ",", $product->price)) ?>">
                        <?= display_error('text_price', $validation_errors) ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <br>
    <div class="row">
        <hr>
    </div>
    <!-- submit -->
    <div class="row">
        <div class="col px-5 pb-3 text-end">
            <a href="<?= site_url('products') ?>" class="btn btn-warning px-4"> <i class="fas fa-ban me-2"></i>Cancelar</a>
            <button type="submit" class="btn btn-primary px-4"><i class="fas fa-check me-2"></i>Salvar </button>
        </div>
    </div>
    <?= form_close() ?>
    
        

    <?php if(!empty($server_error)) : ?>
        <div class="row">
            <div class="col">
                <div class="alert alert-danger p-2">
                    <i class="fa-solid fa-triangle-exclamation me-2"></i><?= $server_error ?>
                </div>
            </div>
        </div>
    <?php endif; ?>

</div>

<script>
    document.querySelector("#file_image").addEventListener('change', function(){
        const product_image = document.querySelector("#product_image");
        const file = this.files[0];
        let reader = new FileReader();

        reader.onloadend = function(){
            product_image.src = reader.result;
        }

        if(file){
            reader.readAsDataURL(file);
        } else {
            product_image.removeAttribute('src');
        }
    });
</script>

<?= $this->endSection() ?>