<!DOCTYPE html>
<html lang="pt-br">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Cardápio</title>
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
        <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
        <style>
            body {
                font-family: 'Inter', sans-serif;
                background-color: #f8f9fa;
            }
        </style>
    </head>
    <body>
        <div class="container py-4">
            <!-- Aqui entra seu menu de categorias e lista de produtos -->

            <!-- Menu de Categorias -->
            <ul class="nav nav-pills mb-4" id="menu-categorias">
                <?php foreach ($categorias as $i => $cat): ?>
                    <li class="nav-item">
                        <a class="nav-link <?= $i == 0 ? 'active' : '' ?>" 
                        href="#" 
                        data-categoria="<?= $cat->id ?>">
                        <?= esc($cat->descricao) ?>
                        </a>
                    </li>
                <?php endforeach; ?>
            </ul>

            <!-- Lista de Produtos -->
            <div class="row" id="lista-produtos">
                <?php foreach ($produtos as $produto): ?>
                    <div class="col-md-4 mb-4 produto" data-categoria="<?= $produto->id_categoria ?>">
                        <div class="card h-100 shadow-sm">
                            <img src="<?= base_url('assets/images/products/' . $produto->image) ?>" 
                                class="card-img-top"
                                style="width: 200px; height: 200px;"
                                alt="<?= esc($produto->nome) ?>">
                            <div class="card-body">
                                <p class="card-title" style="color: #8d8a8aff;">Código:  <?= esc($produto->id) ?></p>
                                <h5 class="card-title" style="color: #0000ff;"><?= esc($produto->nome) ?></h5>
                                <p style="color: #535355ff;"><?= esc($produto->descricao) ?></p>
                            </div>
                            <div class="card-footer text-end fw-bold text-primary">
                                R$ <?= number_format($produto->price, 2, ',', '.') ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </body>
</html>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<!-- Script para filtrar -->
<script>
document.querySelectorAll('#menu-categorias .nav-link').forEach(link => {
    link.addEventListener('click', function(e) {
        e.preventDefault();

        // ativa o link clicado
        document.querySelectorAll('#menu-categorias .nav-link').forEach(l => l.classList.remove('active'));
        this.classList.add('active');

        // pega categoria
        const categoriaId = this.getAttribute('data-categoria');

        // filtra produtos
        document.querySelectorAll('.produto').forEach(prod => {
            if (categoriaId === prod.getAttribute('data-categoria')) {
                prod.style.display = 'block';
            } else {
                prod.style.display = 'none';
            }
        });
    });
});

// Mostrar só a primeira categoria no carregamento
document.addEventListener('DOMContentLoaded', () => {
    const primeiraCategoria = document.querySelector('#menu-categorias .nav-link.active').getAttribute('data-categoria');
    document.querySelectorAll('.produto').forEach(prod => {
        prod.style.display = (primeiraCategoria === prod.getAttribute('data-categoria')) ? 'block' : 'none';
    });
});
</script>

