<?= $this->extend('layouts/layout_auth') ?>
<?= $this->section('content') ?>
<div class="login-box">

    <div class="text-center mb-3">
        <img src="<?= base_url('assets/images/logo.png') ?>" alt="Logo">
    </div>

    <?= form_open('/auth/login_submit') ?>
   
    <hr>

    <div class="mb-3">
        <input class="form-control" type="text" id="text_email" name="text_email" placeholder="E-mail" value="<?= old('text_email') ?>">
        <?= display_error('text_email', $validation_errors) ?>
    </div>
    <div class="mb-3">
        <input class="form-control" type="password" id="text_password" name="text_password" placeholder="Senha de acesso" value="<?= old('text_password') ?>">
        <?= display_error('text_password', $validation_errors) ?>
    </div>
    <div class="mb-3">
        <input type="submit" class="btn-login" value="ENTRAR">
    </div>
    <?= form_close() ?>

    <div class="text-center">
        <p>Esqueceu a senha? <a href="<?= site_url('/auth/forgot_password') ?>" class="login-link">Recuperar senha</a></p>
    </div>

    <?php if (!empty($login_error)) : ?>
        <div class="alert alert-danger text-center p-1">
            <?= $login_error ?>
        </div>
    <?php endif; ?>

</div>

<?= $this->endSection() ?>