<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\RestaurantModel;

class Main extends BaseController
{
    public function index()
    {
       
        $data = [
            'title' => 'Dashboard',
            'page' => 'dashboard',
        ];

        $restaurant_model = new RestaurantModel();

        // Verifica se a sessão tem o usuário
        $user = session()->get('user');
        
        if (!$user || !isset($user['id_restaurant'])) {
            return redirect()->to('/auth/login');
        }

        $id_restaurant = $user['id_restaurant'];
        $data['restaurant'] = $restaurant_model->find($id_restaurant);


        return view('dashboard/home', $data);
    }

    public function no_access_allowed()
    {
        $data = [
            'title' => 'Acesso negado',
            'page' => ''
        ];
        return view('errors/no_access_allowed', $data);
    }
}
