<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\UserModel;

class Home extends BaseController
{
    public function index()
    {

        // Verifica se a sessão tem o usuário
        $teste = session()->get('user');
     
        // Se o usuário estiver logado, redireciona para o dashboard
        if (session()->has('user')) {
            return redirect()->to('/main');
        }

        // Caso contrário, exibe a tela pública
        return view('home/index'); // você criará essa view a seguir
    }


    public function registrarUsuario()
    {
        $nome_completo = $this->request->getPost('text_nome_completo');
        $nome_usuario = $this->request->getPost('text_nome_usuario');
        $email = $this->request->getPost('text_email');
        $password = $this->request->getPost('text_senha');  

        // Validação dos campos
        if (empty($nome_completo)) {
            return redirect()->to(site_url('/#registrar'))->withInput()->with('errors', ['O campo "Nome completo" é obrigatório.']);
        }
        if (empty($nome_usuario)) {
            return redirect()->to(site_url('/#registrar'))->withInput()->with('errors', ['O campo "Nome do usuário" é obrigatório.']);
        }   
        if (empty($email)) {
            return redirect()->to(site_url('/#registrar'))->withInput()->with('errors', ['O Campo "E-mail" é obrigatório.']);
        }   
        
        if ( empty($password)) {
            return redirect()->to(site_url('/#registrar'))->withInput()->with('errors', ['O campo "Senha de acesso" é obrigatório.']);
        }   

        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            return redirect()->to(site_url('/#registrar'))->withInput()->with('errors', ['O campo "E-mail" informado é inválido.']);
        }

        if (strlen($nome_completo) < 3 || strlen($nome_completo) > 100) {
            return redirect()->to(site_url('/#registrar'))->withInput()->with('errors', ['O campo "Nome completo" deve ter entre 3 e 100 caracteres.']);
        }
        
        if (strlen($nome_usuario) < 3 || strlen($nome_usuario) > 20) {
            return redirect()->to(site_url('/#registrar'))->withInput()->with('errors', ['O campo "Nome de usuário" deve ter entre 3 e 20 caracteres.']);
        }
        
        if (strlen($email) < 5 || strlen($email) > 100) {
            return redirect()->to(site_url('/#registrar'))->withInput()->with('errors', ['O campo "E-mail" deve ter entre 3 e 100 caracteres.']);
        }
        if (strlen($password) < 6 || strlen($password) > 20) {
            return redirect()->to(site_url('/#registrar'))->withInput()->with('errors', ['O campo "Senha de acesso" deve ter entre 6 e 20 caracteres.']);
        }

        // Verifica se o nome de usuário já existe
        $users_model = new UserModel();
        $user = $users_model
            ->where('email', $this->request->getPost('text_email'))
            ->first();

        if ($user) {
            return redirect()->to(site_url('/#registrar'))->withInput()->with('errors', ['Já existe outro usuário cadastrado com o mesmo e-mail.']);
        }
        
 
        // Aqui você poderia salvar no banco (simulado abaixo)
        $id_restaurant = 1; // Simulando um ID de restaurante
        $username = $this->request->getPost('text_nome_completo');
        $email = $this->request->getPost('text_email'); 
        $code = bin2hex(random_bytes(16)); // Gerando um código aleatório para o usuário
        $password = $this->request->getPost('text_senha');
        
        
        $data = [
            'id_restaurant' => $id_restaurant,
            'username' => $username,
            'name' => $username,
            'email' => $email,
            'passwrd' => password_hash($password, PASSWORD_DEFAULT),
            'phone' => '(11)9.9544-0698',
            'roles' => '["admin"]',
            'active' => 1,
            'code' => $code,
            'created_at' => date('Y-m-d H:i:s')
        ];

        $users_model->insert($data);
        // Redireciona para a página inicial com uma mensagem de sucesso
        //return redirect()->to(site_url('home'))->with('sucesso', 'Cadastro realizado com sucesso!');

        return redirect()->to(site_url('/#registrar'))->with('sucesso', 'Cadastro realizado com sucesso!, clique em "Entrar" para acessar sua conta.');
    }
    


}
